//Jacek Matulewski, e-mail: jacek@fizyka.umk.pl

#ifndef SZKIELET_H
#define SZKIELET_H

#include "Macierz.h"
#include "Kwaternion.h"
#include <vector>

class Kosc
{
	private:
		Kosc* rodzic;
		std::vector<Kosc*> dzieci;
		double dlugosc;
		Wektor polozenieWzgledemRodzica;
		Macierz orientacjaWzgledemRodzica;		
		
		void DodajKoscDziecko(Kosc* dziecko)
		{
			dzieci.push_back(dziecko);
		}

	public:
		//akcesory
		void UstawOrientacje(Macierz orientacjaWzgledemRodzica)
		{
			this->orientacjaWzgledemRodzica=orientacjaWzgledemRodzica;
		}
		void UstawDlugosc(double dlugosc)
		{
			this->dlugosc=dlugosc;
		}
		void UstawPolozenie(Wektor polozenieWzgledemRodzica)
		{
			this->polozenieWzgledemRodzica=polozenieWzgledemRodzica;
		}

		//konstruktor
		Kosc(Kosc* rodzic,double dlugosc,Wektor polozenieWzgledemRodzica,Macierz orientacjaWzgledemRodzica)
		{
			this->rodzic=rodzic;
			if(rodzic!=NULL) rodzic->DodajKoscDziecko(this);
			UstawDlugosc(dlugosc);
			UstawPolozenie(polozenieWzgledemRodzica);
			UstawOrientacje(orientacjaWzgledemRodzica);			
		}
		
		//metoda odpowiedzialna za renderowanie koci
		void Rysuj(GLUquadricObj* kwadryka,float promien,bool tylkoStawy=false) const
		{
			glPushMatrix();
			double translacja[3];
			this->polozenieWzgledemRodzica.ZapiszWTablicy(translacja);
			glTranslated(translacja[0],translacja[1],translacja[2]); //translacja do pocztku koci
			glColor3f(0.9f,0.5f,0.1f);
			gluSphere(kwadryka,promien,20,20); //rysowanie sfery na pocztku koci			
			double orientacja[16];
			this->orientacjaWzgledemRodzica.KopiaElementow4x4(orientacja);
			glMultMatrixd(orientacja); //ustawianie wzgldem rodzica			
			if(!tylkoStawy) 
			{
				glPushMatrix(); 
				glRotatef(90,0,1,0); 
				gluCylinder(kwadryka,promien,0,this->dlugosc,20,1); 
				glPopMatrix(); //rysowanie walca wzdu koci
			}
			glTranslated(this->dlugosc,0,0); //przesuwanie na koniec koci			
			glColor3f(1,0,0);
			gluSphere(kwadryka,promien,20,20); //rysowanie sfery na kocu koci
			for(unsigned int i=0;i<dzieci.size();++i) dzieci[i]->Rysuj(kwadryka,promien,tylkoStawy); //rekurencyjne wywoania
			glPopMatrix();
		}
};

class Szkielet
{
	protected:
		Kosc* korzen;

	public:		
		void Rysuj(float promien,bool tylkoStawy=false) const
		{
			GLUquadricObj* kwadryka=gluNewQuadric(); //tworzenie obiektu kwadryki 
			gluQuadricDrawStyle(kwadryka,GLU_FILL); //ustalenie stylu rysowania
			korzen->Rysuj(kwadryka,promien,tylkoStawy); //inicjacja rysowania drzewa koci
			gluDeleteQuadric(kwadryka); //usuwanie obiektu 
		}
};

class Reka : public Szkielet
{
	private:
		double l;
		Kosc *ramie,*przedramie,*srodrecze,
			*paliczekBlizszyKciuka,*paliczekSrodkowyKciuka,*paliczekDystalnyKciuka,
			*paliczekBlizszyPalcaWskazujacego,*paliczekSrodkowyPalcaWskazujacego,*paliczekDystalnyPalcaWskazujacego,
			*paliczekBlizszyPalcaSrodkowego,*paliczekSrodkowyPalcaSrodkowego,*paliczekDystalnyPalcaSrodkowego,
			*paliczekBlizszyPalcaSerdecznego,*paliczekSrodkowyPalcaSerdecznego,*paliczekDystalnyPalcaSerdecznego,
			*paliczekBlizszyPalcaMalego,*paliczekSrodkowyPalcaMalego,*paliczekDystalnyPalcaMalego;

	public:
		Reka(double wzorzecDlugosci)
		{
			l=wzorzecDlugosci;
			Macierz macierzJednostkowa=Macierz::Jednostkowa();
			
			ramie=new Kosc(NULL,0.25*l,Wektor(-2,-1.5,0),macierzJednostkowa); //rami
			korzen=ramie;
			przedramie=new Kosc(korzen,0.2*l,Wektor::Zero(),macierzJednostkowa); //przedrami
			srodrecze=new Kosc(przedramie,0.07*l,Wektor::Zero(),macierzJednostkowa); //rdrcze

			//kciuk
			paliczekBlizszyKciuka=new Kosc(srodrecze,0.03*l,Wektor(-0.04*l,0.03*l,0),TworzMacierzObrotuZKataIOsiObrotu(-0.75,Wektor(0,0,1))*TworzMacierzObrotuZKataIOsiObrotu(0.25,Wektor(1,0,0))); //paliczek bliszy
			paliczekSrodkowyKciuka=new Kosc(paliczekBlizszyKciuka,0.02*l,Wektor::Zero(),TworzMacierzObrotuZKataIOsiObrotu(0.25,Wektor(0,0,1))); //paliczek rodkowy
			paliczekDystalnyKciuka=new Kosc(paliczekSrodkowyKciuka,0.02*l,Wektor::Zero(),macierzJednostkowa); //paliczek dystalny
			

			//palec wskazujcy
			paliczekBlizszyPalcaWskazujacego=new Kosc(srodrecze,0.03*l,Wektor(0.005*l,0.025*l,0),macierzJednostkowa); //paliczek bliszy
			paliczekSrodkowyPalcaWskazujacego=new Kosc(paliczekBlizszyPalcaWskazujacego,0.03*l,Wektor::Zero(),macierzJednostkowa); //paliczek rodkowy
			paliczekDystalnyPalcaWskazujacego=new Kosc(paliczekSrodkowyPalcaWskazujacego,0.02*l,Wektor::Zero(),macierzJednostkowa); //paliczek dystalny
			
			//palec rodkowy
			paliczekBlizszyPalcaSrodkowego=new Kosc(srodrecze,0.03*l,Wektor(0.005*l,0.005*l,0),macierzJednostkowa); //paliczek bliszy
			paliczekSrodkowyPalcaSrodkowego=new Kosc(paliczekBlizszyPalcaSrodkowego,0.035*l,Wektor::Zero(),macierzJednostkowa); //paliczek rodkowy
			paliczekDystalnyPalcaSrodkowego=new Kosc(paliczekSrodkowyPalcaSrodkowego,0.02*l,Wektor::Zero(),macierzJednostkowa); //paliczek dystalny

			//palec serdeczny
			paliczekBlizszyPalcaSerdecznego=new Kosc(srodrecze,0.025*l,Wektor(0.005*l,-0.015*l,0),macierzJednostkowa); //paliczek bliszy
			paliczekSrodkowyPalcaSerdecznego=new Kosc(paliczekBlizszyPalcaSerdecznego,0.03*l,Wektor::Zero(),macierzJednostkowa); //paliczek rodkowy
			paliczekDystalnyPalcaSerdecznego=new Kosc(paliczekSrodkowyPalcaSerdecznego,0.02*l,Wektor::Zero(),macierzJednostkowa); //paliczek dystalny

			//palec may
			paliczekBlizszyPalcaMalego=new Kosc(srodrecze,0.02*l,Wektor(0.003*l,-0.035*l,0),macierzJednostkowa); //paliczek bliszy
			paliczekSrodkowyPalcaMalego=new Kosc(paliczekBlizszyPalcaMalego,0.015*l,Wektor::Zero(),macierzJednostkowa); //paliczek rodkowy
			paliczekDystalnyPalcaMalego=new Kosc(paliczekSrodkowyPalcaMalego,0.02*l,Wektor::Zero(),macierzJednostkowa); //paliczek dystalny
		}

		void Victoria() const
		{
			paliczekBlizszyKciuka->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0,Wektor(0,0,1))*TworzMacierzObrotuZKataIOsiObrotu(2.0,Wektor(1,0,0)));
			paliczekSrodkowyKciuka->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			paliczekDystalnyKciuka->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			
			paliczekBlizszyPalcaWskazujacego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.15,Wektor(0,0,1)));
			paliczekBlizszyPalcaSrodkowego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(0.15,Wektor(0,0,1)));

			paliczekBlizszyPalcaSerdecznego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			paliczekSrodkowyPalcaSerdecznego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.5,Wektor(0,1,0)));
			paliczekDystalnyPalcaSerdecznego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0,Wektor(0,1,0)));
			paliczekBlizszyPalcaMalego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			paliczekSrodkowyPalcaMalego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.5,Wektor(0,1,0)));
			paliczekDystalnyPalcaMalego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0,Wektor(0,1,0)));
		}

		void OK() const
		{
			paliczekBlizszyKciuka->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.6,Wektor(0,0,1)));
			paliczekSrodkowyKciuka->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.1,Wektor(0,0,1)));			
			paliczekBlizszyPalcaWskazujacego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			paliczekSrodkowyPalcaWskazujacego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.5,Wektor(0,1,0)));
			paliczekDystalnyPalcaWskazujacego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0,Wektor(0,1,0)));
			paliczekBlizszyPalcaSrodkowego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			paliczekSrodkowyPalcaSrodkowego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.5,Wektor(0,1,0)));
			paliczekDystalnyPalcaSrodkowego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0,Wektor(0,1,0)));
			paliczekBlizszyPalcaSerdecznego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			paliczekSrodkowyPalcaSerdecznego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.5,Wektor(0,1,0)));
			paliczekDystalnyPalcaSerdecznego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0,Wektor(0,1,0)));
			paliczekBlizszyPalcaMalego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5,Wektor(0,1,0)));
			paliczekSrodkowyPalcaMalego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.5,Wektor(0,1,0)));
			paliczekDystalnyPalcaMalego->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0,Wektor(0,1,0)));
		}

		#define _USE_MATH_DEFINES
		#include <math.h>

		void Machanie(double czas,double czestosc) const
		{
			//czstotliwo -> czsto
			czestosc*=2*M_PI;			
			//bark
			ramie->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-1.0-0.1*sin(czestosc*czas),Wektor(0,0,1))*TworzMacierzObrotuZKataIOsiObrotu(0.3,Wektor(1,0,0))); 
			//okie
			przedramie->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.5*(1+sin(czestosc*czas)),Wektor(0,0,1))); 
			//nadgarstek
			srodrecze->UstawOrientacje(TworzMacierzObrotuZKataIOsiObrotu(-0.3*(0.3+sin(czestosc*czas)),Wektor(0,0,1))); 
		}

		void Wzrost(double czas) const
		{
			ramie->UstawDlugosc(czas*l/1000.0);
			przedramie->UstawDlugosc(czas*l/1000.0);
		}
};

#endif